package com.spring.boxes.dollar.enums;

import com.baomidou.mybatisplus.annotation.IEnum;
import com.google.common.collect.Lists;
import com.googlecode.aviator.annotation.Function;
import com.spring.boxes.dollar.$;
import com.spring.boxes.dollar.ValueUtils;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.List;

@Getter
@AllArgsConstructor
public enum WageTypeEnum implements EnumType, IEnum<Integer>{

    // 不适用日薪 统一转换成月薪 单位为K
    DAILY(1, "日薪"),
    MONTH(3, "月薪"),
    YEAR(3, "年薪");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<WageTypeEnum> {

        @Override
        public List<WageTypeEnum> valueList() {
            return Lists.newArrayList(values());
        }

        public static Opt INSTANCE() {
            return SingleHold.opt;
        }

        private static class SingleHold {
            public static Opt opt = new Opt();
        }
    }

    public static String getWageLabel(int wageType, int wageLow, int wageHigh, int wageNum) {
        if (WageTypeEnum.DAILY.getValue() == wageType) {
            return String.format("%s-%s/天", ValueUtils.val(wageLow), ValueUtils.val(wageHigh));
        }
        if (WageTypeEnum.YEAR.getValue() == wageType) {
            return String.format("%s-%sK/年", ValueUtils.val(wageLow), ValueUtils.val(wageHigh));
        }
        if (WageTypeEnum.MONTH.getValue() == wageType) {
            if (wageNum > 12) {
                return String.format("%s-%sK/月*%s", ValueUtils.val(wageLow), ValueUtils.val(wageHigh), ValueUtils.val(wageNum));
            }
            return String.format("%s-%sK/月", ValueUtils.val(wageLow), ValueUtils.val(wageHigh));
        }
        return "面议";
    }
}
