package com.spring.boxes.dollar.enums;

import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.List;

@Getter
@AllArgsConstructor
public enum WidgetTyeEnum implements EnumType {

    PENDANT(1, "挂件"),
    POPUP(2, "弹窗"),
    ADORN(3, "皮肤"),
    BANNER(4, "横幅"),
    GRILLE(5, "格栅"),
    GRIDBOX(6, "金刚"),
    TREATY(7, "协议"),
    EDITOR(8, "编辑器"),
    TABBAR(9, "底部导航"),
    NAVBAR(10, "顶部导航"),
    //
    TOTAL_BOX(17, "统计宫格"),
    HELP_LIST(19, "FAQ"), ;

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<WidgetTyeEnum> {

        @Override
        public List<WidgetTyeEnum> valueList() {
            return Lists.newArrayList(values());
        }

        public static Opt INSTANCE() {
            return SingleHold.opt;
        }

        private static class SingleHold {
            public static Opt opt = new Opt();
        }
    }

}
