package com.spring.boxes.dollar.enums;

import com.baomidou.mybatisplus.annotation.IEnum;
import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.List;

@Getter
@AllArgsConstructor
public enum WorkYearEnum implements EnumType{

    YEAR0(1, "应届生"),
    YEAR0_1(3, "1年以内"),
    YEAR1_3(5, "1-3年"),
    YEAR3_5(7, "3-5年"),
    YEAR5_10(9, "5-10年"),
    YEAR10_OVER(11, "10年以上");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<WorkYearEnum> {

        @Override
        public List<WorkYearEnum> valueList() {
            return Lists.newArrayList(values());
        }

        public static Opt INSTANCE() {
            return SingleHold.opt;
        }

        private static class SingleHold {
            public static Opt opt = new Opt();
        }
    }
}
