package com.spring.boxes.dollar.sample;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class VipMeta {

    @ApiModelProperty("会员等级")
    private int vipType;

    @ApiModelProperty("主标题")
    private String title;

    @ApiModelProperty("子标题")
    private String subTitle;

    @ApiModelProperty("原始价格")
    private long originalPrice;

    @ApiModelProperty("当前价格")
    private long currentPrice;

    @ApiModelProperty("月份周期")
    private int month;

    @ApiModelProperty("权益说明")
    private String introduce;

    public VipMeta(int vipType, String title, String subTitle, long originalPrice, long currentPrice, int month, String introduce) {
        this.vipType = vipType;
        this.title = title;
        this.subTitle = subTitle;
        this.originalPrice = originalPrice;
        this.currentPrice = currentPrice;
        this.month = month;
        this.introduce = introduce;
    }

    @ApiModelProperty("挂件权益")
    private List<Privilege> widgetList;

    @ApiModelProperty("专享权益")
    private List<Privilege> enjoyList;

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    private static class Privilege implements Serializable {

        @ApiModelProperty("专享权益ID")
        private long enjoyId;

        @ApiModelProperty("图标")
        private String icon;

        @ApiModelProperty("文案描述")
        private String text;
    }

    public static List<VipMeta> vipTypeList(){

        List<Privilege> widgetList = Arrays.asList(
                new Privilege(1, "https://oss.anearly.com/static/mutual/pendant/touxiangkuang.png", "星空"),
                new Privilege(2, "https://oss.anearly.com/static/mutual/pendant/touxiangkuang1.png", "关注我"),
                new Privilege(3, "https://oss.anearly.com/static/mutual/pendant/touxiangguajian.png", "夏日冲浪"),
                new Privilege(4, "https://oss.anearly.com/static/mutual/pendant/katongmao.png", "HelloKitty"),
                new Privilege(5, "https://oss.anearly.com/static/mutual/pendant/katongshu.png", "米老鼠"),
                new Privilege(6, "https://oss.anearly.com/static/mutual/pendant/emo.png", "恶魔")
        );

        List<Privilege> enjoyList = Arrays.asList(
                new Privilege(11, "https://oss.anearly.com/static/vip/icon_vip_01@2x.png", "尊贵身份"),
                new Privilege(12, "https://oss.anearly.com/static/vip/icon_vip_02@2x.png", "头像挂件"),
                new Privilege(13, "https://oss.anearly.com/static/vip/icon_vip_03@2x.png", "流量倾斜"),
                new Privilege(14, "https://oss.anearly.com/static/vip/icon_vip_04@2x.png", "无限畅聊"),
                new Privilege(15, "https://oss.anearly.com/static/vip/icon_vip_05@2x.png", "更多特权")
        );

        List<VipMeta> list = new ArrayList<>();
        VipMeta vipMeta1 = new VipMeta(1, "首月优惠", "首月8元", 1000, 800, 1, "首月优惠8元，过期续费10元");
        vipMeta1.setEnjoyList(enjoyList);
        vipMeta1.setWidgetList(widgetList);

        VipMeta vipMeta2 = new VipMeta(2, "3个月", "限时8折",3000, 2400, 3, "3个月会员，限时8折");
        vipMeta2.setEnjoyList(enjoyList);
        vipMeta2.setWidgetList(widgetList);

        VipMeta vipMeta3 = new VipMeta(2, "12个月",  "立减40",12000, 8000, 12, "全年月会员，立减40");
        vipMeta3.setEnjoyList(enjoyList);
        vipMeta3.setWidgetList(widgetList);

        list.add(vipMeta1);
        list.add(vipMeta2);
        list.add(vipMeta3);
        return list;
    }
}
