/*--------------------------------------------------------------------------
 *  Copyright (c) 2010-2020, Elon.su All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the elon developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: Elon.su, you can also mail dennisit@163.com
 *--------------------------------------------------------------------------
 */
package com.spring.boxes.dollar.support;


public class ApiException extends RuntimeException {

    private ApiStatus.Status status;

    public ApiException(ApiStatus.Status status) {
        this(status, status.getMessage());
    }

    public ApiException(ApiStatus.Status status, String message) {
        super(message);
        this.status = status;
    }

    public ApiException(ApiStatus.Status status, String message, Throwable cause) {
        super(message, cause);
        this.status = status;
    }

    public ApiException(ApiStatus.Status status, Throwable cause) {
        super(cause);
        this.status = status;
    }

    public ApiException(ApiStatus.Status status, String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.status = status;
    }

    public ApiException() {
        this(ApiStatus.Status.FAILURE);
    }

    public ApiException(String message) {
        this(ApiStatus.Status.FAILURE, message);
    }

    public ApiException(String message, Throwable cause) {
        this(ApiStatus.Status.FAILURE, message, cause);
    }

    public ApiException(Throwable cause) {
        this(ApiStatus.Status.FAILURE, cause);
    }

    protected ApiException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        this(ApiStatus.Status.FAILURE, message, cause, enableSuppression, writableStackTrace);
    }

    public ApiStatus.Status getStatus() {
        return status;
    }

    public void setStatus(ApiStatus.Status status) {
        this.status = status;
    }
}

