/*--------------------------------------------------------------------------
 *  Copyright (c) 2010-2020, Elon.su All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the elon developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: Elon.su, you can also mail dennisit@163.com
 *--------------------------------------------------------------------------
 */
package com.spring.boxes.dollar.support;

import lombok.Data;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

@Data
@ToString
public class ApiResult<T> implements Serializable {

    private int status;

    private T data;

    private String message;

    public ApiResult() {
        super();
    }

    public ApiResult(ApiStatus status) {
        this(status, null);
    }

    public ApiResult(ApiStatus status, T data) {
        this(status.getStatus(), status.getMessage(), data);
    }

    public ApiResult(int status, String message, T data) {
        this.message = message;
        this.status = status;
        this.data = data;
    }

    public static ApiResult<?> success() {
        return success(StringUtils.EMPTY);
    }

    public static <T> ApiResult<?> success(T data) {
        return new ApiResult<>(ApiStatus.Status.SUCCESS, data);
    }

    public static ApiResult<?> failure() {
        return failure(StringUtils.EMPTY);
    }

    public static ApiResult<?> failure(final String message) {
        ApiStatus status = new ApiStatus() {
            public String getMessage() {
                return StringUtils.isBlank(message) ? ApiStatus.Status.FAILURE.getMessage() : message.trim();
            }

            public int getStatus() {
                return FAILURE;
            }
        };
        return failure(status);
    }

    public static ApiResult<?> failure(ApiStatus status) {
        if (status.getStatus() == ApiStatus.SUCCESS) {
            throw new IllegalArgumentException("failure status cannot be 0. ");
        }
        return new ApiResult<>(status);
    }
}
