package com.spring.boxes.dollar.support;

import lombok.AllArgsConstructor;
import lombok.Getter;

public interface ApiStatus {

    int SUCCESS = Status.SUCCESS.getStatus();
    int FAILURE = Status.FAILURE.getStatus();

    int getStatus();
    String getMessage();

    @Getter
    @AllArgsConstructor
    enum Status implements ApiStatus {

        SUCCESS(0, "执行成功"),
        FREQUENCY(429, "请求量太大被限流"),
        WARN_PERFORMANCE_ISSUE(102, "潜在的性能问题"),
        NO_PERMISSION(403, "请求资源没有权限访问!"),
        FAIL_NOT_FOUND(404, "请求资源不存在"),
        UNAUTHORIZED(401, "服务未授权或授权Token过期"),
        FAIL_INVALID_PARAM(400, "请求参数不匹配"),
        FAIL_VALIDATION(405, "数据校验不通过"),
        FAIL_OPERATION(406, "操作执行失败"),
        FAILURE(500, "网络连接错误,请稍后重试!");

        private final int status;
        private final String message;
    }
}
