package com.spring.boxes.dollar.support;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.io.Serializable;

@Slf4j
@Data
@NoArgsConstructor
@AllArgsConstructor
public class AppVersion implements Serializable {

    @ApiModelProperty("客户端类型:Android/Ios")
    private String appType;

    @ApiModelProperty("APP版本号")
    private String version;

    @ApiModelProperty("APP下载地址")
    private String downUrl;

    // 比较V1是否大于V2版本,大于返回1 等于返回0 小于返回-1
    public static int compareVersion(String version1, String version2) {
        int m = version1.length();
        int n = version2.length();
        int i = 0;
        int j = 0;
        while (i < m || j < n) {
            int num1 = 0;
            int num2 = 0;
            while (i < m && Character.isDigit(version1.charAt(i))) {
                num1 = num1 * 10 + (version1.charAt(i) - '0');
                i++;
            }
            while (j < n && Character.isDigit(version2.charAt(j))) {
                num2 = num2 * 10 + (version2.charAt(j) - '0');
                j++;
            }
            if (num1 > num2) {
                return 1;
            }
            if (num1 < num2) {
                return -1;
            }
            i++;
            j++;
        }
        return 0;
    }

    // 判断V1是否大于V2版本
    public static boolean isUpdate(String version1, String version2){
        return compareVersion(version1, version2) > 0;
    }

}
