package com.spring.boxes.dollar.support;

import org.jasypt.encryption.pbe.StandardPBEByteEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.util.text.BasicTextEncryptor;

public class Encryptor {

    /**
     * 编码 默认算法为"PBEWithMD5AndDES"
     *
     * @param passport   秘钥
     * @param source 原始数据
     * @return 这里每次加密后的密文结果都不一样
     */
    public static String encrypt(String passport, String source) {
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        encryptor.setPassword(passport);
        encryptor.setAlgorithm(StandardPBEByteEncryptor.DEFAULT_ALGORITHM);
        return encryptor.encrypt(source);
    }

    /**
     * 解码 默认算法为"PBEWithMD5AndDES"
     *
     * @param passport   秘钥
     * @param source ji
     * @return 解码结果
     */
    public static String decrypt(String passport, String source) {
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        encryptor.setPassword(passport);
        encryptor.setAlgorithm(StandardPBEByteEncryptor.DEFAULT_ALGORITHM);
        return encryptor.decrypt(source);
    }
}
