/*--------------------------------------------------------------------------
 *  Copyright (c) 2010-2020, Elon.su All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the elon developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: Elon.su, you can also mail dennisit@163.com
 *--------------------------------------------------------------------------
 */
package com.spring.boxes.dollar.support;

import java.util.List;

/**
 * Created by Elon.su on 17/11/14.
 */
public interface EnumAction<T extends EnumType> {

    /**
     * 枚举集合
     *
     * @return 枚举集合
     */
    public List<T> valueList();

    /**
     * 根据数值查询
     *
     * @param value 枚举值
     * @return 枚举
     */
    public T valueGet(int value);

    /**
     * 根据多个值查询
     *
     * @param values 多个枚举值集合
     * @return 枚举集合
     */
    public List<T> valueGet(List<Integer> values);

    /**
     * 抽取多个枚举元素的数值
     *
     * @param enums 多个枚举集合
     * @return 枚举值集合
     */
    public List<Integer> toValues(List<T> enums);

    /**
     * 抽取多个枚举元素的数值
     *
     * @return 元素集合
     */
    public List<Integer> allValues();

    /**
     * 抽取多个枚举元素的标签
     *
     * @param enums 多个枚举集合
     * @return 枚举标签集合
     */
    public List<String> toLabels(List<T> enums);
}
