/*--------------------------------------------------------------------------
 *  Copyright (c) 2010-2020, Elon.su All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the elon developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: Elon.su, you can also mail dennisit@163.com
 *--------------------------------------------------------------------------
 */
package com.spring.boxes.dollar.support;

import com.baomidou.mybatisplus.annotation.IEnum;
import com.spring.boxes.dollar.ValueUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.reflections.ReflectionUtils;

import java.lang.reflect.Method;
import java.util.Optional;

public interface EnumType extends IEnum<Integer> {

    Integer getValue();

    /**
     * 约束标签
     *
     * @return 标签
     */
    String getLabel();

    /**
     * 枚举name
     *
     * @return 名称
     */
    String getName();


    static String getEnumName(String clazzName, int value) {
        Object result = getEnumType(clazzName, "name", value);
        return Optional.ofNullable(result).map(Object::toString).orElse(StringUtils.EMPTY);
    }

    static String getEnumOrdi(String clazzName, int value) {
        Object result = getEnumType(clazzName, "ordinal", value);
        return Optional.ofNullable(result).map(Object::toString).orElse(StringUtils.EMPTY);
    }

    static String getEnumLabel(String clazzName, int value) {
        Object result = getEnumType(clazzName, "getLabel", value);
        return Optional.ofNullable(result).map(Object::toString).orElse(StringUtils.EMPTY);
    }

    static Object getEnumType(String clazzName, String type, int value) {
        try {
            Class<?> clazz = ReflectionUtils.forName(clazzName);
            Object[] objects = clazz.getEnumConstants();
            if (ArrayUtils.getLength(objects) > 0) {
                for (Object object : objects) {
                    Method method = clazz.getMethod("getValue");
                    int rVal = ValueUtils.val((Integer) method.invoke(object), -1);
                    if (value == rVal) {
                        return clazz.getMethod(type).invoke(object);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}
