package com.spring.boxes.dollar.support;

import com.spring.boxes.dollar.JoiningUtils;
import com.spring.boxes.dollar.support.logger.RateLogger;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Slf4j
public class InfoPerfect {

    private static final Logger logger = RateLogger.rateLogger(log);

    // 获取初始标记位状态
    public static int[] getPerfectBit(){
        // 职业-学历-体重-身高-兴趣标签-个性标签-签名-身份证-邮箱-手机-位置-生日-头像-昵称
        int[] bit = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        // 每一项资料完成后,对应位数值标记为1
        List<Integer> array = Arrays.stream(bit).boxed().collect(Collectors.toList());
        System.out.println(JoiningUtils.joinList(array, ""));
        return bit;
    }

    // 获取完善度标记状态
    public static int[] getPerfectBit(People people) {
        int[] bit = getPerfectBit();
        if (StringUtils.isNotBlank(people.getNickname()) && !people.getNickname().equalsIgnoreCase("微信用户")) {
            bit[0] = 1;
        }
        if (StringUtils.isNotBlank(people.getAvatar()) && !people.getAvatar().equalsIgnoreCase("https://oss.anearly.com/static/mine/default_avatar.png")) {
            bit[1] = 1;
        }
        if (Objects.nonNull(people.getBirthday())) {
            bit[2] = 1;
        }
        if (StringUtils.isNotBlank(people.getLocation())) {
            bit[3] = 1;
        }
        if (StringUtils.isNotBlank(people.getPhone())) {
            bit[4] = 1;
        }
        if (StringUtils.isNotBlank(people.getEmail())) {
            bit[5] = 1;
        }
        if(StringUtils.isNotBlank(people.getIdCard())){
            bit[6] = 1;
        }
        if (StringUtils.isNotBlank(people.getSignature())) {
            bit[7] = 1;
        }
        if (StringUtils.isNotBlank(people.getTags())) {
            bit[8] = 1;
        }
        if (StringUtils.isNotBlank(people.getHobby())) {
            bit[9] = 1;
        }
        if (people.getHeight() > 0) {
            bit[10] = 1;
        }
        if(people.getWeight() >= 0){
            bit[11] = 1;
        }
        if(StringUtils.isNotBlank(people.getEducation())){
            bit[12] = 1;
        }
        if(StringUtils.isNotBlank(people.getOccupation())){
            bit[13] = 1;
        }
        // 因为处理时是从高位处理的, 所以需要进行反转
        ArrayUtils.reverse(bit);
        logger.info("[资料完成度]:" + Arrays.toString(bit));
        return bit;
    }

    // 获取标记位状态值
    public static int getPerfectVal(People people) {
        int[] bit = getPerfectBit(people);
        String str = JoiningUtils.joinList(Arrays.stream(bit).boxed().collect(Collectors.toList()), "");
        return Integer.parseInt(str, 2);
    }

    public static boolean isBasicFill(People people){
        // 原始数组
        int[] bit = getPerfectBit(people);
        ArrayUtils.reverse(bit);
        return bit[0] == 1 && bit[1] == 1;
    }

    @Data
    public static class People {

        @ApiModelProperty("头像")
        private String avatar;

        @ApiModelProperty("昵称")
        private String nickname;

        @ApiModelProperty("生日")
        private LocalDate birthday;

        @ApiModelProperty("位置")
        private String location;

        @ApiModelProperty("手机")
        private String phone;

        @ApiModelProperty("邮箱")
        private String email;

        @ApiModelProperty("签名")
        private String signature;

        @ApiModelProperty("标签")
        private String tags;

        @ApiModelProperty("兴趣爱好")
        private String hobby;

        @ApiModelProperty("身高")
        private int height;

        @ApiModelProperty("体重")
        private int weight;

        @ApiModelProperty("学历")
        private String education;

        @ApiModelProperty("学校")
        private String schoolName;

        @ApiModelProperty("公司")
        private String company;

        @ApiModelProperty("职业")
        private String occupation;

        @ApiModelProperty("身份认证")
        private String idCard;

        @ApiModelProperty("微信号")
        private String wechat;
    }

    public static void main(String[] args) {
        People person = new People();
        person.setNickname("AAAA");
        person.setSignature("345345");
        person.setAvatar("!111");
        System.out.println(getPerfectVal(person));
        System.out.println(isBasicFill(person));
    }
}
