package com.spring.boxes.dollar.support;

import java.util.Locale;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum Language {

    zh("中文", Locale.CHINESE),
    zh_TW("中文繁体", Locale.TRADITIONAL_CHINESE),
    zh_HK("中文香港", Locale.TRADITIONAL_CHINESE), // zh_HK => zh-TW
    en("英语", Locale.ENGLISH),
    ko("韩语", Locale.KOREAN),
    ja("日语", Locale.JAPANESE),
    in("印尼语", Locale.forLanguageTag("in")),
    th("泰国语", Locale.forLanguageTag("th")),
    pt("葡萄牙语", Locale.forLanguageTag("pt")),
    de("德语", Locale.GERMAN),
    ms("马来语", Locale.forLanguageTag("ms")),
    tl("菲律宾语", Locale.forLanguageTag("tl")),
    ru("俄语", Locale.forLanguageTag("ru")),
    vi("越南语", Locale.forLanguageTag("vi")),
    my("缅甸语", Locale.forLanguageTag("my")),
    hi("印地语", Locale.forLanguageTag("hi")),
    tr("土耳其语", Locale.forLanguageTag("tr")),
    es("西班牙语", Locale.forLanguageTag("es")),
    ar("阿拉伯语", Locale.forLanguageTag("ar")),
    fr("法语", Locale.FRENCH),
    it("意大利", Locale.ITALIAN),
    bn("孟加拉语", Locale.forLanguageTag("bn")),
    te("泰卢固语", Locale.forLanguageTag("te")),
    mr("马拉地语", Locale.forLanguageTag("mr")),
    ta("泰米尔语", Locale.forLanguageTag("ta")),
    ur("乌尔都语", Locale.forLanguageTag("ur")),
    kn("卡纳达语", Locale.forLanguageTag("kn")),
    gu("古吉拉特语", Locale.forLanguageTag("gu")),
    bh("比哈尔语", Locale.forLanguageTag("bh")),
    pa("旁遮普语", Locale.forLanguageTag("pa")),
    ml("马拉雅拉姆语", Locale.forLanguageTag("ml")),
    raj("拉贾斯坦语", Locale.forLanguageTag("raj"));

    private final String remark;
    private final Locale locale;

}
