package com.spring.boxes.dollar.support;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

import com.google.common.base.Preconditions;
import com.spring.boxes.dollar.ValueUtils;

/**
 * 组合Key辅助工具
 */
public final class PairKey {

    /**
     * 获取Key编号
     *
     * @param key 聚合Key
     * @return 编号
     */
    public static long getId(String key) {
        String[] array = validPairArray(key);
        return ValueUtils.val(Long.parseLong(array[1]));
    }

    /**
     * 获取Key类型
     *
     * @param key 聚合Key
     * @return 类型
     */
    public static String getType(String key) {
        String[] array = validPairArray(key);
        return array[0];
    }

    /**
     * 获取组合Key
     *
     * @param key 聚合Key
     * @return 类型和ID的映射结果
     */
    public static Pair<String, Long> getPair(String key) {
        String[] array = validPairArray(key);
        return Pair.of(array[0], Long.parseLong(array[1]));
    }

    /**
     * 获取聚合Key
     *
     * @param type 类型
     * @param id 编号
     * @return 聚合Key
     */
    public static String getKey(String type, long id) {
        return String.format(KEY_FORMAT, type, id);
    }

    /**
     * 校验聚合Key
     *
     * @param key 聚合Key
     * @return 返回结果
     */
    public static String[] validPairArray(String key) {
        Preconditions.checkArgument(StringUtils.isNotBlank(key), "账号错误!type:id");
        String[] array = StringUtils.split(key, ":");
        Preconditions.checkArgument(ArrayUtils.getLength(array) == 2, "账号错误!type:id");
        return array;
    }

    private static final String KEY_FORMAT = "%s:%s";

}
