package com.spring.boxes.dollar.support;

import com.google.common.collect.Lists;
import com.spring.boxes.dollar.JSONUtils;
import com.spring.boxes.dollar.term.ItemView;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class SquareType {

    // 即遇话题分类
    public static List<ItemView> anearlyList() {
        List<Long> ids = Arrays.asList(1000L, 1005L, 1185L, 1175L, 1180L, 1190L);
        return defaultList()
                .stream()
                .filter(e -> ids.contains(e.getId()))
                .sorted(Comparator.comparing(ItemView::getPriority))
                .collect(Collectors.toList());
    }

    // 社交行业分类
    public static List<ItemView> defaultList(){
        List<ItemView> itemList = Lists.newArrayList();
        itemList.add(new ItemView(1000, "生活", "", "", 1));
        itemList.add(new ItemView(1005, "情感", "", "", 2));
        itemList.add(new ItemView(1010, "次元", "", "", 100));
        itemList.add(new ItemView(1015, "明星", "", "", 100));
        itemList.add(new ItemView(1020, "校园", "", "", 100));
        itemList.add(new ItemView(1025, "职场", "", "", 100));
        itemList.add(new ItemView(1030, "阅读", "", "", 100));
        itemList.add(new ItemView(1035, "美食", "", "", 100));
        itemList.add(new ItemView(1040, "时尚", "", "", 100));
        itemList.add(new ItemView(1045, "音乐", "", "", 100));
        itemList.add(new ItemView(1150, "影视", "", "", 100));
        itemList.add(new ItemView(1155, "游戏", "", "", 6));
        itemList.add(new ItemView(1160, "八卦", "", "", 100));
        itemList.add(new ItemView(1165, "金融", "", "", 100));
        itemList.add(new ItemView(1170, "科技", "", "", 100));
        itemList.add(new ItemView(1175, "才艺", "", "", 4));
        itemList.add(new ItemView(1180, "颜值", "", "", 5));
        itemList.add(new ItemView(1185, "搞笑", "", "", 3));
        itemList.add(new ItemView(1190, "社交", "", "", 4));
        return itemList;
    }

    // 企业圈子分类
    public static List<ItemView> recruitList(){
        List<ItemView> itemList = Lists.newArrayList();
        itemList.add(new ItemView(2000, "科技", "", ""));
        itemList.add(new ItemView(2005, "金融", "", ""));
        itemList.add(new ItemView(2010, "地产", "", ""));
        itemList.add(new ItemView(2015, "零售", "", ""));
        itemList.add(new ItemView(2020, "贸易", "", ""));
        itemList.add(new ItemView(2025, "服务", "", ""));
        itemList.add(new ItemView(2030, "传媒", "", ""));
        itemList.add(new ItemView(2055, "其它", "", ""));
        return itemList;
    }

    public static void main(String[] args) {
        System.out.println(JSONUtils.toJSON(anearlyList()));
    }
}
