package com.spring.boxes.dollar.support;

import com.google.common.base.Preconditions;

@FunctionalInterface
public interface ThrowableConsumer<T, X extends Throwable> {

    void accept(T t) throws X;

    default ThrowableConsumer<T, X> andThen(ThrowableConsumer<? super T, X> after) {
        Preconditions.checkNotNull(after);
        return t -> {
            accept(t);
            after.accept(t);
        };
    }
}