package com.spring.boxes.dollar.support;

import com.google.common.collect.Lists;
import lombok.experimental.UtilityClass;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

@UtilityClass
public class TreeFunction {

    /**
     * 递归实现List折叠成Tree
     *
     * @param list 集合
     * @param <T>  泛型约束
     * @return 折叠后的集合对象
     */
    public static <T extends TreeHandler<T>> List<T> tree(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }

        List<T> items = Lists.newArrayList();
        // 抽取根节点
        list.stream().filter(x -> x.isTreeRoot()).forEach(x -> items.add(x));

        // 递归组装成tree
        for (T item : items) {
            tree(list, item);
        }
        return items;
    }


    /**
     * Tree形折叠
     *
     * @param list 集合
     * @param t    集合元素
     * @param <T>  泛型约束
     */
    private static <T extends TreeHandler<T>> void tree(List<T> list, T t) {
        final String pid = t.getTreeId();
        final List<T> data = Lists.newArrayList();
        list.stream()
                .filter((x) -> StringUtils.isNotBlank(x.getTreeParentId()) && pid.equals(x.getTreeParentId()))
                .forEach((x) -> {
                    data.add(x);
                    // 递归添加
                    tree(list, x);
                });
        if (!data.isEmpty()) {
            t.setSubList(data);
        }
    }
}
