package com.spring.boxes.dollar.support;

import java.io.Serializable;
import java.util.List;

public abstract class TreeHandler<T> implements Serializable {

    /**
     * 树形子节点
     */
    private List<T> subList;

    /**
     * 树节点根条件
     *
     * @return 是否根节点
     */
    public abstract boolean isTreeRoot();

    /**
     * 当前节点编号
     *
     * @return 根节点编号
     */
    public abstract String getTreeId();

    /**
     * 父节点编号
     *
     * @return 父节点编号
     */
    public abstract String getTreeParentId();


    /**
     * 树形节点子节点装载
     *
     * @param subList 子节点集合
     */
    public void setSubList(List<T> subList) {
        this.subList = subList;
    }

    /**
     * 获取子节点
     *
     * @return 子节点集合
     */
    public List<T> getSubList() {
        return this.subList;
    }

}
