package com.spring.boxes.dollar.support;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Objects;
import java.util.stream.Collectors;

import org.apache.commons.collections4.MapUtils;
import org.apache.ibatis.reflection.property.PropertyNamer;

import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.support.LambdaMeta;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.spring.boxes.dollar.JSONUtils;
import com.spring.boxes.dollar.StringUtils;

import cn.hutool.core.bean.BeanUtil;

// Builder模式的不可变Map构建
public class UnModifyMap implements Serializable {

    private UnModifyMap() { }

    public static <T> Builder<T> builder() {
        return new Builder<>();
    }

    public static class Builder<T> {

        private final Map<String, Object> variables = new LinkedHashMap<>();

        public Builder<T> put(String key, Object val) {
            variables.put(key, val);
            return this;
        }

        public Builder<T> put(Object... keysValues) {
            if (keysValues.length % 2 != 0) {
                throw new IllegalArgumentException(
                        "wrong number of arguments for met, keysValues length can not be odd");
            }
            for (int i = keysValues.length - 2; i >= 0; i -= 2) {
                Object key = keysValues[i];
                Object value = keysValues[i + 1];
                variables.put(String.valueOf(key), value);
            }
            return this;
        }

        public Builder<T> ofBeanMap(Object object) {
            Map<String, Object> map =
                    MapUtils.emptyIfNull(BeanUtil.beanToMap(object))
                            .entrySet()
                            .stream()
                            .filter(e -> StringUtils.isNotBlank(e.getKey()) && Objects.nonNull(e.getValue()))
                            .collect(Collectors.toMap(Entry::getKey, Entry::getValue));
            if (MapUtils.isNotEmpty(map)) {
                variables.putAll(map);
            }
            return this;
        }

        public Builder<T> put(SFunction<T, ?> column, String value) {
            LambdaMeta meta = LambdaUtils.extract(column);
            String fieldName = PropertyNamer.methodToProperty(meta.getImplMethodName());
            if (StringUtils.isNotBlank(fieldName)) {
                variables.put(fieldName, value);
            }
            return this;
        }

        public Map<String, Object> build() {
            return Collections.unmodifiableMap(variables);
        }

        @Override
        public String toString() {
            return JSONUtils.toJSON(variables);
        }
    }

    @Override
    public String toString() {
        return JSONUtils.toJSON(this);
    }
}
