package com.spring.boxes.dollar.support;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import javax.servlet.*;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;

@Order(3)
@WebFilter(filterName = "performanceFilter", urlPatterns = "/*")
public class UrlPerformanceFilter implements Filter {

    private static final Logger LOG = LoggerFactory.getLogger(UrlPerformanceFilter.class);

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        LOG.debug("[performance] performance init.");
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest) servletRequest;
        HttpServletResponse response = (HttpServletResponse) servletResponse;
        String params = formatParameters(request);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        filterChain.doFilter(request, response);
        stopWatch.stop();
        LOG.debug("[performance] {uri:" + request.getRequestURI() + ", time :" + stopWatch.getTotalTimeMillis() + ", params:" + params + "}");
    }

    private String formatParameters(HttpServletRequest request){
        StringBuilder parameters = new StringBuilder();
        Map<String, String[]> paramsMap = request.getParameterMap();
        if (paramsMap != null && !paramsMap.isEmpty()) {
            for (Map.Entry<String, String[]> entry : paramsMap.entrySet()) {
                parameters.append(entry.getKey()).append(":").append(
                        StringUtils.arrayToDelimitedString(entry.getValue(), ",")).append(";");
            }
        }
        return parameters.toString();
    }

    @Override
    public void destroy() {
        LOG.debug("[performance] performance destroy.");
    }


}
