package com.spring.boxes.dollar.support;

import com.googlecode.aviator.annotation.Import;
import com.googlecode.aviator.annotation.ImportScope;
import com.spring.boxes.dollar.$;
import lombok.experimental.UtilityClass;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.text.StringSubstitutor;

import java.util.Map;

import static org.apache.commons.text.StringSubstitutor.DEFAULT_VAR_START;


@Slf4j
@UtilityClass
@Import(ns = "Utility", scopes = ImportScope.Static)
public class Utility extends $ {

    public String getAvatar(){
        return Avatar.getAvatar();
    }

    public String substitutor(String source, Map<String, Object> valueMap) {
        StringSubstitutor stringSubstitutor = new StringSubstitutor(valueMap, DEFAULT_VAR_START, StringSubstitutor.DEFAULT_VAR_END);
        return stringSubstitutor.replace(source);
    }

    public static String urlEncode(String data) {
        // return UrlUtils.encode(source, Charsets.UTF_8);
        return encode(data)
                .replace("\r\n", "")
                .replace("/", "_")
                .replace("+", "-");
    }

    public static String urlDecode(String data) {
        data = data.replaceAll("-", "+").replaceAll("_", "/");
        return decode(data);
    }
}
