package com.spring.boxes.dollar.support.cryptor;

import lombok.experimental.UtilityClass;

@UtilityClass
public class IdEncryptor {

    public static final int[] DEFAULT = new int[]{7, 7, 3, 0, 2, 2, 1, 8, 4, 3, 9};

    public static final int[] A = new int[]{20, 19, 6, 8, 16, 18, 1, 2, 9, 3};
    public static final int[] B = new int[]{13, 14, 18, 34, 18, 9, 4, 3, 10, 26};
    public static final int[] C = new int[]{4, 21, 3, 41, 7, 19, 34, 13, 30, 1};
    public static final int[] D = new int[]{19, 34, 13, 30, 1, 4, 21, 3, 41, 7};
    public static final int[] E = new int[]{12, 8, 39, 1, 3, 9, 28, 6, 5, 22};
    public static final int[] F = new int[]{2, 8, 9, 1, 8, 6, 5, 2, 3, 7};
    public static final int[] G = new int[]{36, 6, 5, 22, 12, 8, 39, 1, 2, 9};
    public static final int[] H = new int[]{8, 39, 1, 2, 9, 36, 6, 5, 22, 12};
    public static final int[] I = new int[]{28, 6, 5, 22, 12, 8, 39, 1, 3, 9};
    public static final int[] J = new int[]{3, 2, 15, 17, 7, 1, 9, 1, 8, 27};
    public static final int[] K = new int[]{5, 23, 1, 2, 9, 12, 3, 10, 3, 7};
    public static final int[] L = new int[]{13, 12, 5, 17, 27, 13, 19, 22, 8, 2};
    public static final int[] M = new int[]{7, 19, 21, 3, 4, 18, 6, 1, 30, 9};
    public static final int[] N = new int[]{26, 7, 36, 17, 9, 18, 8, 6, 5, 52};
    public static final int[] O = new int[]{18, 12, 11, 2, 5, 1, 3, 21, 23, 8};
    public static final int[] P = new int[]{4, 13, 26, 7, 11, 33, 8, 2, 1, 9};
    public static final int[] Q = new int[]{24, 5, 1, 3, 21, 23, 8, 12, 11, 2};
    public static final int[] R = new int[]{51, 22, 36, 18, 7, 28, 9, 12, 2, 8};
    public static final int[] S = new int[]{21, 23, 8, 12, 11, 2, 24, 5, 1, 3};
    public static final int[] T = new int[]{51, 22, 36, 18, 7, 23, 8, 12, 11, 2};
    public static final int[] U = new int[]{26, 27, 29, 6, 5, 2, 17, 15, 10, 7};
    public static final int[] V = new int[]{20, 9, 1, 3, 21, 23, 8, 12, 11, 2};
    public static final int[] W = new int[]{21, 2, 19, 1, 15, 22, 7, 3, 4, 6};
    public static final int[] X = new int[]{16, 10, 9, 3, 21, 23, 8, 12, 11, 2};
    public static final int[] Y = new int[]{6, 17, 19, 23, 21, 3, 8, 12, 11, 2};
    public static final int[] Z = new int[]{31, 12, 9, 14, 3, 1, 28, 6, 8, 2};

    public static long skipEncrypt(long id) {
        return SkipJack.encrypt(id, IdEncryptor.DEFAULT);
    }

    public static long skipDecrypt(long id) {
        return SkipJack.decrypt(id, IdEncryptor.DEFAULT);
    }

    public static SkipJack toSkipJack(int[] cipher) {
        return SkipJack.of(cipher);
    }

    public static String skipEncryptId(long id) {
        return Base62.toBase62(SkipJack.encrypt(id, IdEncryptor.DEFAULT));
    }

    public static long skipDecryptId(String uuid) {
        return SkipJack.decrypt(Base62.toLongVal(uuid), IdEncryptor.DEFAULT);
    }

    public static String skipEncryptId(long id, int[] cipher) {
        return Base62.toBase62(SkipJack.encrypt(id, cipher));
    }

    public static long skipDecryptId(String uuid, int[] cipher) {
        return SkipJack.decrypt(Base62.toLongVal(uuid), cipher);
    }

}
