package com.spring.boxes.dollar.support.filter;

import com.spring.boxes.dollar.term.ClientInfo;
import com.spring.boxes.dollar.term.ScopeKey;
import eu.bitwalker.useragentutils.UserAgent;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.annotation.Order;
import org.springframework.lang.NonNull;
import org.springframework.util.StopWatch;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Locale;
import java.util.UUID;

@Slf4j
@Order(20)
public class UserRequestInfoFilter extends OncePerRequestFilter {

    // Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36
    @Override
    protected void doFilterInternal(HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException,
            IOException {
        if (request.getRequestURI().equals("/")) {
            filterChain.doFilter(request, response);
            return;
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        String userAgent = request.getHeader("User-Agent");
        UserAgent agent = UserAgent.parseUserAgentString(userAgent);
        ClientInfo clientInfo = ClientInfo
                .builder()
                .appId(ScopeKey.getAppId())
                .userId(ScopeKey.getUserId())
                .deviceId(UUID.randomUUID().toString())
                .locale(Locale.getDefault().toString())
                .userAgent(agent)
                .build();
        ScopeKey.CLIENT_INFO.set(clientInfo);
        stopWatch.stop();
        log.debug("[UserRequestInfo] [{}.clientInfo] [{}ms]", request.getRequestURI(), stopWatch.getLastTaskTimeMillis());
        stopWatch.start();
        filterChain.doFilter(request, response);
        stopWatch.stop();
        log.debug("[UserRequestInfo] [{}.httpHandle] [{}ms]", request.getRequestURI(), stopWatch.getLastTaskTimeMillis());
    }
}
