package com.spring.boxes.dollar.support.instant;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;

@Deprecated
@Getter
@AllArgsConstructor
public enum EventEnum {

    _HEART_BEAT(0, "心跳检测"),
    _EVENT_ACK(1, "响应消息"),
    _AUTH_TOKEN(2, "鉴权消息"),
    _PUSH_BROADCAST(10, "信令广播"),
    _PUSH_DIRECTIVE(11, "信令单播"),
    _CHAT_TING_SINGLE(20, "单聊消息"),
    _CHAT_TING_GROUP(21, "群聊消息"),
    _CHAT_PULL_HISTORY(30, "历史消息"),
    _CHAT_PULL_OFFLINE(31, "离线消息");

    private final int event;
    private final String name;

    public static EventEnum getByEvent(int event) {
        return Arrays.stream(EventEnum.values())
                .filter(e -> e.getEvent() == event)
                .findFirst()
                .orElse(null);
    }
}
