package com.spring.boxes.dollar.support.live;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class LiveVideoInfo {
    /**
     * 视频流协议：
     * rts = 阿里云极速直播，对应阿里云SDK的rts
     * flv = flv格式，各个CDN厂商通用
     * hls = hls格式，各个CDN厂商通用，主要用于 H5 Webview 中
     */
    @ApiModelProperty("视频流协议")
    private String protocol;

    @ApiModelProperty("可用的视频服务器信息")
    private List<LiveServerInfo> servers;
}
