package com.spring.boxes.dollar.support.locale;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * 国家码or区域定义
 **/
@Getter
@AllArgsConstructor
public enum I18NRegionEnum {

    /**
     * 美国
     */
    US("US", "1", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "美国"),
    /**
     * 中国
     */
    CHINA("CN", "86", I18NLanguageEnum.ZH, I18NCurrencyEnum.CNY, "中国"),
    /**
     * 香港
     */
    HONG_KONG("HK", "852", I18NLanguageEnum.ZH_TW, I18NCurrencyEnum.HKD, "中国香港"),

    /**
     * 台湾
     */
    TAI_WAN("TW", "886", I18NLanguageEnum.ZH_TW2, I18NCurrencyEnum.USD, "中国台湾"),

    /**
     * 澳门
     */
    MACAO("MO", "853", I18NLanguageEnum.ZH_MO, I18NCurrencyEnum.USD, "中国澳门"),

    /**
     * 日本
     */
    JAPANESE("JP", "81", I18NLanguageEnum.JA, I18NCurrencyEnum.JPY, "日本"),

    /**
     * 新加坡
     */
    SINGAPORE("SG", "65", I18NLanguageEnum.EN, I18NCurrencyEnum.SGD, "新加坡"),

    /**
     * 马来西亚
     */
    MALAYSIA("MY", "60", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "马来西亚"),

    /**
     * 意大利
     */
    IT("IT", "39", I18NLanguageEnum.ITALIAN, I18NCurrencyEnum.EUR, "意大利"),

    /**
     * 阿富汗
     **/
    AFGHANISTAN("AF", "93", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "阿富汗"),

    /**
     * 阿尔巴尼亚
     **/
    ALBANIA("AL", "355", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "阿尔巴尼亚"),

    /**
     * 阿尔及利亚
     **/
    ALGERIA("DZ", "213", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "阿尔及利亚"),

    /**
     * 美属萨摩亚
     **/
    AMERICAN_SAMOA("AS", "1684", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "美属萨摩亚"),

    /**
     * 安道尔
     **/
    ANDORRA("AD", "376", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "安道尔"),

    /**
     * 安哥拉
     **/
    ANGOLA("AO", "244", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "安哥拉"),

    /**
     * 安圭拉
     **/
    ANGUILLA("AI","1264", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"安圭拉"),

    /**
     * 安提瓜和巴布达
     **/
    ANTIGUA_AND_BARBUDA("AG","1268", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"安提瓜和巴布达"),

    /**
     * 阿根廷
     **/
    ARGENTINA("AR","54", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"阿根廷"),

    /**
     * 亚美尼亚
     **/
    ARMENIA("AM","374", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"亚美尼亚"),

    /**
     * 阿鲁巴
     **/
    ARUBA("AW","297", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"阿鲁巴"),

    /**
     * 澳大利亚
     **/
    AUSTRALIA("AU","61", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"澳大利亚"),

    /**
     * 奥地利
     **/
    AUSTRIA("AT","43", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"奥地利"),

    /**
     * 阿塞拜疆
     **/
    AZERBAIJAN("AZ","994", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"阿塞拜疆"),

    /**
     * 巴哈马
     **/
    BAHAMAS("BS","1242", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"巴哈马"),

    /**
     * 巴林
     **/
    BAHRAIN("BH","973", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"巴林"),

    /**
     * 孟加拉国
     **/
    BANGLADESH("BD","880", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"孟加拉国"),

    /**
     * 巴巴多斯
     **/
    BARBADOS("BB","1246", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"巴巴多斯"),

    /**
     * 白俄罗斯
     **/
    BELARUS("BY","375", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"白俄罗斯"),

    /**
     * 比利时
     **/
    BELGIUM("BE","32", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"比利时"),

    /**
     * 伯利兹
     **/
    BELIZE("BZ","501", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"伯利兹"),

    /**
     * 贝宁
     **/
    BENIN("BJ","229", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"贝宁"),

    /**
     * 百慕大群岛
     **/
    BERMUDA("BM","1441", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"百慕大群岛"),

    /**
     * 不丹
     **/
    BHUTAN("BT","975", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"不丹"),

    /**
     * 玻利维亚
     **/
    BOLIVIA("BO","591", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"玻利维亚"),

    /**
     * 波斯尼亚和黑塞哥维那
     **/
    BOSNIA_AND_HERZEGOVINA("BA","387", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"波斯尼亚和黑塞哥维那"),

    /**
     * 博茨瓦纳
     **/
    BOTSWANA("BW","267", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"博茨瓦纳"),

    /**
     * 巴西
     **/
    BRAZIL("BR","55", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"巴西"),

    /**
     * 文莱
     **/
    BRUNEI("BN","673", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"文莱"),

    /**
     * 保加利亚
     **/
    BULGARIA("BG","359", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"保加利亚"),

    /**
     * 布基纳法索
     **/
    BURKINA_FASO("BF","226", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"布基纳法索"),

    /**
     * 布隆迪
     **/
    BURUNDI("BI","257", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"布隆迪"),

    /**
     * 柬埔寨
     **/
    CAMBODIA("KH","855", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"柬埔寨"),

    /**
     * 喀麦隆
     **/
    CAMEROON("CM","237", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"喀麦隆"),

    /**
     * 加拿大
     **/
    CANADA("CA","1", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"加拿大"),

    /**
     * 开普
     **/
    CAPE_VERDE("CV","238", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"开普"),

    /**
     * 开曼群岛
     **/
    CAYMAN_ISLANDS("KY","1345", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"开曼群岛"),

    /**
     * 中非共和国
     **/
    CENTRAL_AFRICAN_REPUBLIC("CF","236", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"中非共和国"),

    /**
     * 乍得
     **/
    CHAD("TD","235", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"乍得"),

    /**
     * 智利
     **/
    CHILE("CL","56", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"智利"),

    /**
     * 哥伦比亚
     **/
    COLOMBIA("CO","57", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"哥伦比亚"),

    /**
     * 科摩罗
     **/
    COMOROS("KM","269", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"科摩罗"),

    /**
     * 库克群岛
     **/
    COOK_ISLANDS("CK","682", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"库克群岛"),

    /**
     * 哥斯达黎加
     **/
    COSTA_RICA("CR","506", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"哥斯达黎加"),

    /**
     * 克罗地亚
     **/
    CROATIA("HR","385", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"克罗地亚"),

    /**
     * 古巴
     **/
    CUBA("CU","53", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"古巴"),

    /**
     * 库拉索
     **/
    CURACAO("CW","599", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"库拉索"),

    /**
     * 塞浦路斯
     **/
    CYPRUS("CY","357", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"塞浦路斯"),

    /**
     * 捷克
     **/
    CZECH("CZ","420", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"捷克"),

    /**
     * 刚果民主共和国
     **/
    DEMOCRATIC_REPUBLIC_OF_THE_CONGO("CD","243", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"刚果民主共和国"),

    /**
     * 丹麦
     **/
    DENMARK("DK","45", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"丹麦"),

    /**
     * 吉布提
     **/
    DJIBOUTI("DJ","253", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"吉布提"),

    /**
     * 多米尼加
     **/
    DOMINICA("DM","1767", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"多米尼加"),

    /**
     * 多米尼加共和国
     **/
    DOMINICAN_REPUBLIC("DO","1809", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"多米尼加共和国"),

    /**
     * 厄瓜多尔
     **/
    ECUADOR("EC","593", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"厄瓜多尔"),

    /**
     * 埃及
     **/
    EGYPT("EG","20", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"埃及"),

    /**
     * 萨尔瓦多
     **/
    EL_SALVADOR("SV","503", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"萨尔瓦多"),

    /**
     * 赤道几内亚
     **/
    EQUATORIAL_GUINEA("GQ","240", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"赤道几内亚"),

    /**
     * 厄立特里亚
     **/
    ERITREA("ER","291", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"厄立特里亚"),

    /**
     * 爱沙尼亚
     **/
    ESTONIA("EE","372", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"爱沙尼亚"),

    /**
     * 埃塞俄比亚
     **/
    ETHIOPIA("ET","251", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"埃塞俄比亚"),

    /**
     * 法罗群岛
     **/
    FAROE_ISLANDS("FO","298", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"法罗群岛"),

    /**
     * 斐济
     **/
    FIJI("FJ","679", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"斐济"),

    /**
     * 芬兰
     **/
    FINLAND("FI","358", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"芬兰"),

    /**
     * 法国
     **/
    FRANCE("FR","33", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"法国"),

    /**
     * 法属圭亚那
     **/
    FRENCH_GUIANA("GF","594", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"法属圭亚那"),

    /**
     * 法属波利尼西亚
     **/
    FRENCH_POLYNESIA("PF","689", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"法属波利尼西亚"),

    /**
     * 加蓬
     **/
    GABON("GA","241", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"加蓬"),

    /**
     * 冈比亚
     **/
    GAMBIA("GM","220", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"冈比亚"),

    /**
     * 格鲁吉亚
     **/
    GEORGIA("GE","995", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"格鲁吉亚"),

    /**
     * 德国
     **/
    GERMANY("DE","49", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"德国"),

    /**
     * 加纳
     **/
    GHANA("GH","233", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"加纳"),

    /**
     * 直布罗陀
     **/
    GIBRALTAR("GI","350", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"直布罗陀"),

    /**
     * 希腊
     **/
    GREECE("GR","30", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"希腊"),

    /**
     * 格陵兰岛
     **/
    GREENLAND("GL","299", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"格陵兰岛"),

    /**
     * 格林纳达
     **/
    GRENADA("GD","1473", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"格林纳达"),

    /**
     * 瓜德罗普岛
     **/
    GUADELOUPE("GP","590", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"瓜德罗普岛"),

    /**
     * 关岛
     **/
    GUAM("GU","1671", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"关岛"),

    /**
     * 瓜地马拉
     **/
    GUATEMALA("GT","502", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"瓜地马拉"),

    /**
     * 几内亚
     **/
    GUINEA("GN","224", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"几内亚"),

    /**
     * 几内亚比绍共和国
     **/
    GUINEA_BISSAU("GW","245", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"几内亚比绍共和国"),

    /**
     * 圭亚那
     **/
    GUYANA("GY","592", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"圭亚那"),

    /**
     * 海地
     **/
    HAITI("HT","509", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"海地"),

    /**
     * 洪都拉斯
     **/
    HONDURAS("HN","504", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"洪都拉斯"),

    /**
     * 匈牙利
     **/
    HUNGARY("HU","36", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"匈牙利"),

    /**
     * 冰岛
     **/
    ICELAND("IS","354", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"冰岛"),

    /**
     * 印度
     **/
    INDIA("IN","91", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"印度"),

    /**
     * 印度尼西亚
     **/
    INDONESIA("ID","62", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"印度尼西亚"),

    /**
     * 伊朗
     **/
    IRAN("IR","98", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"伊朗"),

    /**
     * 伊拉克
     **/
    IRAQ("IQ","964", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"伊拉克"),

    /**
     * 爱尔兰
     **/
    IRELAND("IE","353", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"爱尔兰"),

    /**
     * 以色列
     **/
    ISRAEL("IL","972", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"以色列"),

    /**
     * 象牙海岸
     **/
    IVORY_COAST("CI","225", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"象牙海岸"),

    /**
     * 牙买加
     **/
    JAMAICA("JM","1876", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"牙买加"),

    /**
     * 约旦
     **/
    JORDAN("JO","962", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"约旦"),

    /**
     * 哈萨克斯坦
     **/
    KAZAKHSTAN("KZ","7", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"哈萨克斯坦"),

    /**
     * 肯尼亚
     **/
    KENYA("KE","254", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"肯尼亚"),

    /**
     * 基里巴斯
     **/
    KIRIBATI("KI","686", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"基里巴斯"),

    /**
     * 科威特
     **/
    KUWAIT("KW","965", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"科威特"),

    /**
     * 吉尔吉斯斯坦
     **/
    KYRGYZSTAN("KG","996", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"吉尔吉斯斯坦"),

    /**
     * 老挝
     **/
    LAOS("LA","856", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"老挝"),

    /**
     * 拉脱维亚
     **/
    LATVIA("LV","371", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"拉脱维亚"),

    /**
     * 黎巴嫩
     **/
    LEBANON("LB","961", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"黎巴嫩"),

    /**
     * 莱索托
     **/
    LESOTHO("LS","266", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"莱索托"),

    /**
     * 利比里亚
     **/
    LIBERIA("LR","231", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"利比里亚"),

    /**
     * 利比亚
     **/
    LIBYA("LY","218", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"利比亚"),

    /**
     * 列支敦士登
     **/
    LIECHTENSTEIN("LI","423", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"列支敦士登"),

    /**
     * 立陶宛
     **/
    LITHUANIA("LT","370", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"立陶宛"),

    /**
     * 卢森堡
     **/
    LUXEMBOURG("LU","352", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"卢森堡"),

    /**
     * 马其顿
     **/
    MACEDONIA("MK","389", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"马其顿"),

    /**
     * 马达加斯加
     **/
    MADAGASCAR("MG","261", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"马达加斯加"),

    /**
     * 马拉维
     **/
    MALAWI("MW","265", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"马拉维"),

    /**
     * 马尔代夫
     **/
    MALDIVES("MV","960", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"马尔代夫"),

    /**
     * 马里
     **/
    MALI("ML","223", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"马里"),

    /**
     * 马耳他
     **/
    MALTA("MT","356", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"马耳他"),

    /**
     * 马提尼克
     **/
    MARTINIQUE("MQ","596", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"马提尼克"),

    /**
     * 毛里塔尼亚
     **/
    MAURITANIA("MR","222", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"毛里塔尼亚"),

    /**
     * 毛里求斯
     **/
    MAURITIUS("MU","230", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"毛里求斯"),

    /**
     * 马约特
     **/
    MAYOTTE("YT","269", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"马约特"),

    /**
     * 墨西哥
     **/
    MEXICO("MX","52", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"墨西哥"),

    /**
     * 摩尔多瓦
     **/
    MOLDOVA("MD","373", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"摩尔多瓦"),

    /**
     * 摩纳哥
     **/
    MONACO("MC","377", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"摩纳哥"),

    /**
     * 蒙古
     **/
    MONGOLIA("MN","976", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"蒙古"),

    /**
     * 黑山
     **/
    MONTENEGRO("ME","382", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"黑山"),

    /**
     * 蒙特塞拉特岛
     **/
    MONTSERRAT("MS","1664", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"蒙特塞拉特岛"),

    /**
     * 摩洛哥
     **/
    MOROCCO("MA","212", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"摩洛哥"),

    /**
     * 莫桑比克
     **/
    MOZAMBIQUE("MZ","258", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"莫桑比克"),

    /**
     * 缅甸
     **/
    MYANMAR("MM","95", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"缅甸"),

    /**
     * 纳米比亚
     **/
    NAMIBIA("NA","264", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"纳米比亚"),

    /**
     * 尼泊尔
     **/
    NEPAL("NP","977", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"尼泊尔"),

    /**
     * 荷兰
     **/
    NETHERLANDS("NL","31", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"荷兰"),

    /**
     * 新喀里多尼亚
     **/
    NEW_CALEDONIA("NC","687", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"新喀里多尼亚"),

    /**
     * 新西兰
     **/
    NEW_ZEALAND("NZ","64", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"新西兰"),

    /**
     * 尼加拉瓜
     **/
    NICARAGUA("NI","505", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"尼加拉瓜"),

    /**
     * 尼日尔
     **/
    NIGER("NE","227", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"尼日尔"),

    /**
     * 尼日利亚
     **/
    NIGERIA("NG","234", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"尼日利亚"),

    /**
     * 挪威
     **/
    NORWAY("NO","47", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"挪威"),

    /**
     * 阿曼
     **/
    OMAN("OM","968", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"阿曼"),

    /**
     * 巴基斯坦
     **/
    PAKISTAN("PK","92", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"巴基斯坦"),

    /**
     * 帕劳
     **/
    PALAU("PW","680", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"帕劳"),

    /**
     * 巴勒斯坦
     **/
    PALESTINE("BL","970", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"巴勒斯坦"),

    /**
     * 巴拿马
     **/
    PANAMA("PA","507", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"巴拿马"),

    /**
     * 巴布亚新几内亚
     **/
    PAPUA_NEW_GUINEA("PG","675", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"巴布亚新几内亚"),

    /**
     * 巴拉圭
     **/
    PARAGUAY("PY","595", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"巴拉圭"),

    /**
     * 秘鲁
     **/
    PERU("PE","51", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"秘鲁"),

    /**
     * 菲律宾
     **/
    PHILIPPINES("PH","63", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"菲律宾"),

    /**
     * 波兰
     **/
    POLAND("PL","48", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"波兰"),

    /**
     * 葡萄牙
     **/
    PORTUGAL("PT","351", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"葡萄牙"),

    /**
     * 波多黎各
     **/
    PUERTO_RICO("PR","1787", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"波多黎各"),

    /**
     * 卡塔尔
     **/
    QATAR("QA","974", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"卡塔尔"),

    /**
     * 刚果共和国
     **/
    REPUBLIC_OF_THE_CONGO("CG","242", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"刚果共和国"),

    /**
     * 留尼汪
     **/
    RÉUNION_ISLAND("RE","262", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"留尼汪"),

    /**
     * 罗马尼亚
     **/
    ROMANIA("RO","40", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"罗马尼亚"),

    /**
     * 俄罗斯
     **/
    RUSSIA("RU","7", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"俄罗斯"),

    /**
     * 卢旺达
     **/
    RWANDA("RW","250", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"卢旺达"),

    /**
     * 圣基茨和尼维斯
     **/
    SAINT_KITTS_AND_NEVIS("KN","1869", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"圣基茨和尼维斯"),

    /**
     * 圣露西亚
     **/
    SAINT_LUCIA("LC","1758", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"圣露西亚"),

    /**
     * 圣彼埃尔和密克隆岛
     **/
    SAINT_PIERRE_AND_MIQUELON("PM","508", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"圣彼埃尔和密克隆岛"),

    /**
     * 圣文森特和格林纳丁斯
     **/
    SAINT_VINCENT_AND_THE_GRENADINES("VC","1784", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"圣文森特和格林纳丁斯"),

    /**
     * 萨摩亚
     **/
    SAMOA("WS","685", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"萨摩亚"),

    /**
     * 圣马力诺
     **/
    SAN_MARINO("SM","378", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"圣马力诺"),

    /**
     * 圣多美和普林西比
     **/
    SAO_TOME_AND_PRINCIPE("ST","239", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"圣多美和普林西比"),

    /**
     * 沙特阿拉伯
     **/
    SAUDI_ARABIA("SA","966", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"沙特阿拉伯"),

    /**
     * 塞内加尔
     **/
    SENEGAL("SN","221", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"塞内加尔"),

    /**
     * 塞尔维亚
     **/
    SERBIA("RS","381", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"塞尔维亚"),

    /**
     * 塞舌尔
     **/
    SEYCHELLES("SC", "248", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "塞舌尔"),

    /**
     * 塞拉利昂
     **/
    SIERRA_LEONE("SL", "232", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "塞拉利昂"),

    /**
     * 圣马丁岛（荷兰部分）
     **/
    SAINT_MAARTEN_DUTCH_PART("SX", "1721", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "圣马丁岛（荷兰部分）"),

    /**
     * 斯洛伐克
     **/
    SLOVAKIA("SK", "421", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "斯洛伐克"),

    /**
     * 斯洛文尼亚
     **/
    SLOVENIA("SI", "386", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "斯洛文尼亚"),

    /**
     * 所罗门群岛
     **/
    SOLOMON_ISLANDS("SB", "677", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "所罗门群岛"),

    /**
     * 索马里
     **/
    SOMALIA("SO", "252", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "索马里"),

    /**
     * 南非
     **/
    SOUTH_AFRICA("ZA", "27", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "南非"),

    /**
     * 韩国
     **/
    SOUTH_KOREA("KR", "82", I18NLanguageEnum.ZH_TW, I18NCurrencyEnum.KRW, "韩国"),

    /**
     * 西班牙
     **/
    SPAIN("ES", "34", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "西班牙"),

    /**
     * 斯里兰卡
     **/
    SRI_LANKA("LK", "94", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "斯里兰卡"),

    /**
     * 苏丹
     **/
    SUDAN("SD", "249", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "苏丹"),

    /**
     * 苏里南
     **/
    SURINAME("SR", "597", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "苏里南"),

    /**
     * 斯威士兰
     **/
    SWAZILAND("SZ", "268", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "斯威士兰"),

    /**
     * 瑞典
     **/
    SWEDEN("SE", "46", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "瑞典"),

    /**
     * 瑞士
     **/
    SWITZERLAND("CH", "41", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "瑞士"),

    /**
     * 叙利亚
     **/
    SYRIA("SY", "963", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "叙利亚"),

    /**
     * 塔吉克斯坦
     **/
    TAJIKISTAN("TJ","992", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"塔吉克斯坦"),

    /**
     * 坦桑尼亚
     **/
    TANZANIA("TZ","255", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"坦桑尼亚"),

    /**
     * 泰国
     **/
    THAILAND("TH","66", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"泰国"),

    /**
     * 东帝汶
     **/
    TIMOR_LESTE("TL","670", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"东帝汶"),

    /**
     * 多哥
     **/
    TOGO("TG","228", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"多哥"),

    /**
     * 汤加
     **/
    TONGA("TO","676", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"汤加"),

    /**
     * 特立尼达和多巴哥
     **/
    TRINIDAD_AND_TOBAGO("TT","1868", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"特立尼达和多巴哥"),

    /**
     * 突尼斯
     **/
    TUNISIA("TN","216", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"突尼斯"),

    /**
     * 土耳其
     **/
    TURKEY("TR","90", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"土耳其"),

    /**
     * 土库曼斯坦
     **/
    TURKMENISTAN("TM","993", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"土库曼斯坦"),

    /**
     * 特克斯和凯科斯群岛
     **/
    TURKS_AND_CAICOS_ISLANDS("TC","1649", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"特克斯和凯科斯群岛"),

    /**
     * 乌干达
     **/
    UGANDA("UG","256", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"乌干达"),

    /**
     * 乌克兰
     **/
    UKRAINE("UA","380", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"乌克兰"),

    /**
     * 阿拉伯联合酋长国
     **/
    UNITED_ARAB_EMIRATES("AE","971", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"阿拉伯联合酋长国"),

    /**
     * 英国
     **/
    UNITED_KINGDOM("GB","44", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"英国"),

    /**
     * 乌拉圭
     **/
    URUGUAY("UY","598", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"乌拉圭"),

    /**
     * 乌兹别克斯坦
     **/
    UZBEKISTAN("UZ","998", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"乌兹别克斯坦"),

    /**
     * 瓦努阿图
     **/
    VANUATU("VU","678", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"瓦努阿图"),

    /**
     * 委内瑞拉
     **/
    VENEZUELA("VE","58", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"委内瑞拉"),

    /**
     * 越南
     **/
    VIETNAM("VN","84", I18NLanguageEnum.EN, I18NCurrencyEnum.USD,"越南"),

    /**
     * 英属处女群岛
     **/
    VIRGIN_ISLANDS_BRITISH("VG", "1340", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "英属处女群岛"),

    /**
     * 美属维尔京群岛
     **/
    VIRGIN_ISLANDS_US("VI", "1284", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "美属维尔京群岛"),

    /**
     * 也门
     **/
    YEMEN("YE", "967", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "也门"),

    /**
     * 赞比亚
     **/
    ZAMBIA("ZM", "260", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "赞比亚"),

    /**
     * 津巴布韦
     **/
    ZIMBABWE("ZW", "263", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "津巴布韦"),
    ;

    private static final Map<String, I18NRegionEnum> REGION_ENUM_MAP;
    private static final Set<String> GLOBAL_REGION_ENUM_SET;
    private static final Set<I18NRegionEnum> MIN_UNIT_YUAN;

    static {
        Map<String, I18NRegionEnum> temp = new HashMap<>();
        Set<I18NRegionEnum> minUnitYuanRegions = new HashSet<>();
        for (I18NRegionEnum regionEnum : EnumSet.allOf(I18NRegionEnum.class)) {
            temp.put(regionEnum.countryCode, regionEnum);
            // 计算最小结算单位默认是元的地区
            Set<I18NCurrencyEnum> minUnitYuanCurrency = I18NCurrencyEnum.getMinUnitYuanCurrency();
            if (minUnitYuanCurrency.contains(regionEnum.getDefaultCurrency())) {
                minUnitYuanRegions.add(regionEnum);
            }
        }
        REGION_ENUM_MAP = ImmutableMap.copyOf(temp);
        Set<String> tempSet = new HashSet<>();
        // 需要确认具体有哪些地区
        String[] specialRegion = {"HK", "TW", "MO", "JP", "US", "KR"};
        Collections.addAll(tempSet, specialRegion);
        GLOBAL_REGION_ENUM_SET = ImmutableSet.copyOf(tempSet);
        MIN_UNIT_YUAN = ImmutableSet.copyOf(minUnitYuanRegions);
    }

    public final String countryCode;
    public final String regionCode;
    public final I18NLanguageEnum defaultLanguage;
    public final I18NCurrencyEnum defaultCurrency;
    public final String brief;

    public static Map<String, I18NRegionEnum> getRegionEnumMap() {
        return REGION_ENUM_MAP;
    }

    public static Set<String> getRegionEnumSet() {
        return GLOBAL_REGION_ENUM_SET;
    }


    /**
     * 根据language获取GlobalRegionEnum
     *
     * @param countryCode 语言入参
     * @return GlobalRegionEnum by countryCode mapping
     */
    public static I18NRegionEnum getRegionEnumBy(String countryCode) {
        return REGION_ENUM_MAP.get(countryCode);
    }

    /**
     * 获取格式化regionCode
     *
     * @param countryCode 国家码
     * @return 区域码
     */
    public static String getFormatRegionCode(String countryCode) {
        I18NRegionEnum regionEnum = getRegionEnumBy(countryCode);
        Preconditions.checkArgument(regionEnum != null, "not found region by " + countryCode);
        return String.format("+%s", regionEnum.regionCode);
    }

    /**
     * 对是否特殊地区进行判断
     * @param countryCode 国家码
     * @return 根据国家码返回判断结果
     */
    public static boolean isSpecialRegion(String countryCode){
        return !GLOBAL_REGION_ENUM_SET.contains(countryCode);
    }

    /**
     * 获取最小单位是元的地区
     */
    public static Set<I18NRegionEnum> getMinUnitYuanRegions() {
        return MIN_UNIT_YUAN;
    }

    /**
     * 判断是否是最小币种元
     *
     * @param countryCode 目前韩国和日本最小单位元，返回ture。null和其他返回false
     */
    public static boolean isMinUnitYuanRegion(String countryCode) {
        if (countryCode == null) {
            return false;
        }

        return MIN_UNIT_YUAN.stream().anyMatch(p -> p.getCountryCode().equals(countryCode.toUpperCase()));
    }
}

