package com.spring.boxes.dollar.support.logger;

import com.google.common.collect.Lists;
import com.spring.boxes.dollar.JoiningUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.*;

@Slf4j
public final class LoggerTruck implements Serializable {

    private static final Integer TAGS_SIZE = 1024;

    private static String LOG_TRUCK = "#LOG#";

    private final Map<String, String> tagsMap = new HashMap<String, String>();

    private LoggerTruck() { }

    public static LoggerTruck builder() {
        return new LoggerTruck();
    }

    public LoggerTruck seed(String seed) {
        if (StringUtils.isBlank(seed)) {
            seed = LOG_TRUCK;
        }
        LOG_TRUCK = seed;
        return this;
    }

    public LoggerTruck tag(String k, Object v) {
        v = null == v ? (String) null : String.valueOf(v);
        return tag(k, String.valueOf(v));
    }

    public LoggerTruck tag(String k, boolean v) {
        return tag(k, v ? "true" : "false");
    }

    public LoggerTruck tag(String k, char c) {
        return tag(k, String.valueOf(c));
    }

    public LoggerTruck tag(String k, int v) {
        return tag(k, String.valueOf(v));
    }

    public LoggerTruck tag(String k, long v) {
        return tag(k, String.valueOf(v));
    }

    public LoggerTruck tag(String k, float v) {
        return tag(k, String.valueOf(v));
    }

    public LoggerTruck tag(String k, double v) {
        return tag(k, String.valueOf(v));
    }

    public LoggerTruck tag(String k, char v[]) {
        return tag(k, new String(v));
    }

    public LoggerTruck tag(String k, byte v[]) {
        return tag(k, new String(v, StandardCharsets.UTF_8));
    }

    public LoggerTruck tag(String k, String v) {
        k = colation(k);
        v = colation(v);
        if (StringUtils.isBlank(k)) {
            return this;
        }
        if (isTagsFull()) {
            log.error("no space left in LogTruck tags(max={}) map for {}={}", TAGS_SIZE, k, v);
            return this;
        }
        tagsMap.put(k, v);
        return this;
    }

    public LoggerTruck tag(Map<String, String> tags) {
        if (null == tags || tags.isEmpty()) {
            return this;
        }
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            this.tag(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public LoggerTruck action(String action) {
        return tag("Action", action);
    }

    public Map<String, String> getTags() {
        return tagsMap;
    }

    public String getTag(String k) {
        return tagsMap.get(colation(k));
    }

    private String colation(String s) {
        if (StringUtils.isEmpty(s)) {
            return StringUtils.EMPTY;
        }
        return s.replaceAll("=", StringUtils.EMPTY).replaceAll(StringUtils.SPACE, StringUtils.EMPTY);
    }

    private boolean isTagsFull() {
        if (getTags().isEmpty()) {
            return false;
        }
        return getTags().size() > TAGS_SIZE;
    }

    public String toString() {
        List<String> list = Lists.newArrayList();
        getTags().forEach((k, v) -> {
            list.add(k + "=" + v);
        });
        return LOG_TRUCK + " = {" + StringUtils.join(list, StringUtils.SPACE) + "}";

    }

    public String build() {
        return toString();
    }

    public static String join(Collection<?> coll, String split) {
        return JoiningUtils.joinList(Arrays.asList(coll.toArray()), split);
    }

}
