package com.spring.boxes.dollar.support.pattern;

import lombok.extern.slf4j.Slf4j;

import java.util.regex.Pattern;

@Slf4j
public class PatternUtility {

    public static boolean isMatch(String source, String regex) {
        return Pattern.matches(regex, source);
    }

    /**
     * <a href="https://fakenumber.net/">生成多个国家地区手机号码</a>
     * @param phoneNumber 手机号码
     * @param countryCode 国家区域
     *   String phoneNumber = "+821012345678";
     *   String regionCode = "KR";
     * @return 合规返回true, 反之false

    public static boolean isPhone(String countryCode, String phoneNumber) {
        PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
        try {
            I18NRegionEnum regionEnum = I18NRegionEnum.getRegionEnumBy(StringUtils.upperCase(countryCode));
            if(Objects.isNull(regionEnum)){
                log.error("校验警告！无效的区域{}", countryCode);
                return false;
            }
            if(!StringUtils.startsWith(phoneNumber,"+")){
                phoneNumber = I18NRegionEnum.getFormatRegionCode(countryCode);
            }
            Phonenumber.PhoneNumber numberProto = phoneUtil.parse(phoneNumber, countryCode);
            return phoneUtil.isValidNumber(numberProto);
        } catch (Exception e) {
            log.debug("isPhone: {} / {} error: {}", phoneNumber, countryCode, e.getLocalizedMessage(), e);
        }
        return false;
    }*/

}
