package com.spring.boxes.dollar.support.privacy.jackson;

import com.fasterxml.jackson.annotation.JacksonAnnotationsInside;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

// 展示层数据脱敏，单向加密不支持解码
// https://blog.csdn.net/qq_42221135/article/details/125410400
@Target(ElementType.FIELD) // 作用在字段上
@Retention(RetentionPolicy.RUNTIME) // class文件中保留，运行时也保留，能通过反射读取到
@JacksonAnnotationsInside // 表示自定义自己的注解PrivacyEncrypt
@JsonSerialize(using = PrivacyFieldSerializer.class) // 该注解使用序列化的方式
public @interface PrivacyField {

    PrivacyType type() default PrivacyType.DEFAULT;
}
