package com.spring.boxes.dollar.support.privacy.jackson;

import org.apache.commons.lang3.StringUtils;

@FunctionalInterface
public interface PrivacySupplier {

    String accept(String source);

    class DefaultPrivacySupplier implements PrivacySupplier {
        @Override
        public String accept(String source) {
            int size = StringUtils.length(source);
            if (size == 0) {
                return StringUtils.EMPTY;
            }
            if (size == 1) {
                return source.charAt(0) + StringUtils.repeat(DEFAULT_SYMBOL, 4);
            }
            return source.charAt(0) + StringUtils.repeat(DEFAULT_SYMBOL, 3) + source.charAt(size - 1);
        }
    }

    String DEFAULT_SYMBOL = "*";
}
