package com.spring.boxes.dollar.support.privacy.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.spring.boxes.dollar.StringUtils;
import com.spring.boxes.dollar.support.Encryptor;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.IOException;
import java.util.Objects;

@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class PrivacyVirtualSerializer extends JsonSerializer<String> implements ContextualSerializer {

    private String secret;

    @Override
    public void serialize(final String origin, final JsonGenerator jsonGenerator, final SerializerProvider serializerProvider) throws IOException {
        if (StringUtils.isNotBlank(origin)) {
            jsonGenerator.writeString(Encryptor.encrypt(secret, origin));
        }
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        if (Objects.nonNull(beanProperty)) {
            if (Objects.equals(beanProperty.getType().getRawClass(), String.class)) {
                PrivacyVirtual privacyEncrypt = beanProperty.getAnnotation(PrivacyVirtual.class);
                if (Objects.isNull(privacyEncrypt)) {
                    privacyEncrypt = beanProperty.getContextAnnotation(PrivacyVirtual.class);
                }
                if (Objects.nonNull(privacyEncrypt)) {
                    return new PrivacyVirtualSerializer(privacyEncrypt.secret());
                }
            }
            return serializerProvider.findValueSerializer(beanProperty.getType(), beanProperty);
        }
        return serializerProvider.findNullValueSerializer(null);
    }
}
