package com.spring.boxes.dollar.support.privacy.mybatis;

import com.spring.boxes.dollar.support.Encryptor;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

public interface IEncryptor {

    String encrypt(String source) ;

    String decrypt(String source);

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    final class DefaultEncryptor implements IEncryptor {

        private String password;

        @Override
        public String encrypt(String source) {
            return Encryptor.encrypt(this.password, source);
        }

        @Override
        public String decrypt(String source) {
            return Encryptor.decrypt(this.password, source);
        }

    }
}
