package com.spring.boxes.dollar.support.push;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class PushArgument implements Serializable {

    @ApiModelProperty("应用编号")
    private long appId;

    @ApiModelProperty("用户编号")
    private Long userId;

    @ApiModelProperty("查询语言")
    private String language;

    @ApiModelProperty("模版Key")
    private String templateKey;

    @ApiModelProperty("业务域")
    private String type;

    @ApiModelProperty("推送方式")
    private List<PushType> pushTypes;

    @ApiModelProperty("模版参数")
    private Map<String, Object> templateArgs;

    @ApiModelProperty("上线文扩展参数")
    private Map<String, Object> extensionArgs;

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class Attachment implements Serializable {
        private String attachmentName;
        private String path;
    }
}
