package com.spring.boxes.dollar.support.push;

import com.google.common.base.Preconditions;
import com.spring.boxes.dollar.support.template.Template;
import com.spring.boxes.dollar.support.template.TemplateLoader;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

import java.util.List;
import java.util.Map;
import java.util.Objects;

@Slf4j
public class PushTemplate implements PushPayload {

    private TemplateLoader templateLoader;

    private Map<String, PushPayload> pushFunctionMap;

    @Override
    public void push(PushArgument argument) {
        Preconditions.checkArgument(Objects.nonNull(argument), "推送上下文入参为空");
        Template localeTemplate = this.templateLoader.queryTemplate(argument.getAppId(), argument.getTemplateKey(), argument.getLanguage());
        Preconditions.checkArgument(Objects.nonNull(localeTemplate), String.format("触达模版无效:%s:%s", argument.getTemplateKey(), argument.getLanguage()));
        Preconditions.checkArgument(CollectionUtils.isNotEmpty(argument.getPushTypes()), String.format("触达模版推送方式为空:%s:%s", argument.getTemplateKey(), argument.getLanguage()));
        List<String> argList = localeTemplate.getArgList();
        for (String arg : argList) {
            if (Objects.isNull(MapUtils.getObject(argument.getTemplateArgs(), arg))) {
                throw new IllegalArgumentException(String.format("触达参数缺失:%s", arg));
            }
        }
        for (PushType pushType : argument.getPushTypes()) {
            PushPayload pushFunction = pushFunctionMap.get(pushType.getClazz());
            if (Objects.isNull(pushFunction)) {
                log.error("[推送]推送方式{}缺少实现{}", pushType.getLabel(), pushType.getClazz());
            }
            String content = templateLoader.substitutor(localeTemplate.getContent(), argument.getTemplateArgs());
            localeTemplate.setContent(content);
            pushFunction.push(argument);
        }
    }

}
