package com.spring.boxes.dollar.support.queue;

import org.springframework.data.redis.core.StringRedisTemplate;

import com.spring.boxes.dollar.JSONUtils;
import com.spring.boxes.dollar.StringUtils;

import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;

// 消息推送器
@Slf4j
@NoArgsConstructor
@AllArgsConstructor
public class MessagePublisher {

    private StringRedisTemplate stringRedisTemplate;

    public void sendMessage(MessageData messageData) {
        String message = JSONUtils.toJSON(messageData);
        if(StringUtils.isBlank(message)){
            return;
        }
        stringRedisTemplate.convertAndSend(MessageTopic.DEFAULT, message);
    }

}
