package com.spring.boxes.dollar.support.queue;

import java.util.Map;
import java.util.Objects;

import org.apache.commons.collections4.MapUtils;
import org.springframework.context.ApplicationContext;

import com.spring.boxes.dollar.JSONUtils;
import com.spring.boxes.dollar.StringUtils;

import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;

// 消息接收转发器
@Slf4j
@AllArgsConstructor
public class MessageReceiver {

    private ApplicationContext applicationContext;

    /**
     * 消息处理适配器
     * @param message 消息体
     */
    public void onMessage(String message) {
        Map<String, MessageConsumer> consumerMap = applicationContext.getBeansOfType(MessageConsumer.class);
        if (StringUtils.isBlank(message) || MapUtils.isEmpty(consumerMap)) {
            return;
        }
        log.info("[queue][onMessage] message:{}", message);
        MessageData messageData = JSONUtils.fromJSON(message, MessageData.class);
        if (Objects.isNull(messageData)) {
            return;
        }
        String type = messageData.getType();
        String data = messageData.getData();
        if (StringUtils.isBlank(type) || StringUtils.isBlank(data)) {
            return;
        }
        log.info("[queue][onMessage] type:{}, data:{}", type, data);
        consumerMap.forEach((k, v) -> {
            log.info("[queue][onMessage] consumer:{} v.type:{}", k, v.type());
            if (type.equals(v.type())) {
                v.onMessage(data);
            }
        });
    }

}
