package com.spring.boxes.dollar.support.ratelimit;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

import com.google.common.util.concurrent.RateLimiter;

/**
 * RateLimiter既不是接口，也不是可继承的设计，所以采用如下方式
 */
public class DynamicRateLimiter {

    private final Supplier<RateLimiter> rateLimiterSupplier;

    public DynamicRateLimiter(Supplier<RateLimiter> rateLimiterSupplier) {
        this.rateLimiterSupplier = rateLimiterSupplier;
    }

    public double acquire() {
        return rateLimiterSupplier.get().acquire();
    }

    public double acquire(int permits) {
        return rateLimiterSupplier.get().acquire(permits);
    }

    public boolean tryAcquire(int permits) {
        return rateLimiterSupplier.get().tryAcquire(permits);
    }

    public boolean tryAcquire() {
        return rateLimiterSupplier.get().tryAcquire();
    }

    public boolean tryAcquire(Duration timeout) {
        return rateLimiterSupplier.get().tryAcquire(timeout);
    }

    public boolean tryAcquire(int permits, Duration timeout) {
        return rateLimiterSupplier.get().tryAcquire(permits, timeout);
    }

    public boolean tryAcquire(int permits, long timeout, TimeUnit unit) {
        return rateLimiterSupplier.get().tryAcquire(permits, timeout, unit);
    }

    public boolean tryAcquire(long timeout, TimeUnit unit) {
        return rateLimiterSupplier.get().tryAcquire(timeout, unit);
    }

    public double getRate(){
        return rateLimiterSupplier.get().getRate();
    }


}
