package com.spring.boxes.dollar.support.reflect;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;

import org.apache.commons.collections4.ListUtils;
import org.springframework.util.ReflectionUtils;

/**
 * 泛化调用
 */
public class DataReflect {

    /**
     * 泛化调用
     *
     * @param instance 服务实例
     * @param methodName 方法名
     * @param parametersTypes 服务meta信息
     * @param parametersValues 调用真实入参
     * @return 返回结果
     * @throws Exception 异常类型
     */
    public static Object beanInvoke(Object instance, String methodName, List<String> parametersTypes, List<Object> parametersValues) throws Exception {
        List<Class<?>> paramTypes = TypeReflect.forNames(parametersTypes);
        Method method = ReflectionUtils
                .findMethod(instance.getClass(), methodName, paramTypes.toArray(new Class[0]));
        if (Objects.isNull(method)) {
            throw new RuntimeException("未找到匹配的方法");
        }
        return method.invoke(instance, ListUtils.emptyIfNull(parametersValues).toArray(new Object[0]));
    }

    /**
     * 泛化调用
     *
     * @param className 服务类名
     * @param methodName 方法名
     * @param parametersTypes 服务meta信息
     * @param parametersValues 调用真实入参
     * @return 返回结果
     * @throws Exception 异常类型
     */
    public static Object classInvoke(String className, String methodName, List<String> parametersTypes, List<Object> parametersValues)
            throws Exception {
        Class<?> serviceClass = TypeReflect.forName(className);
        List<Class<?>> paramTypes = TypeReflect.forNames(parametersTypes);
        Method method = ReflectionUtils
                .findMethod(serviceClass, methodName, paramTypes.toArray(new Class[0]));
        if (Objects.isNull(method)) {
            throw new RuntimeException("未找到匹配的方法");
        }
        return method.invoke(serviceClass.getDeclaredConstructor().newInstance(), ListUtils.emptyIfNull(parametersValues).toArray(new Object[0]));
    }

}
