package com.spring.boxes.dollar.support.socket;

import com.spring.boxes.dollar.JoiningUtils;
import com.spring.boxes.dollar.enums.ChatTypeEnum;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ImSocket {

    public static String getRoomId(ChatTypeEnum chatType, long from, long to){
        String pattern = "_room_%s_%s";
        if(ChatTypeEnum.SINGLE == chatType){
            List<Long> list = Stream.of(from, to).sorted().collect(Collectors.toList());
            String sorted = JoiningUtils.joinList(list, "_");
            return String.format(pattern, chatType.getName(), sorted);
        }
        return String.format(pattern, chatType.getName(), to);
    }
}
