package com.spring.boxes.dollar.support.socket.model;

import com.spring.boxes.dollar.support.socket.payload.ChattingPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

// 最近联系人
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ContactInfo implements Serializable {

    @ApiModelProperty("用户ID/群组ID")
    private long id;

    @ApiModelProperty("用户/群组(1用户 2群组)")
    private int type;

    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("头像")
    private String avatar;

    @ApiModelProperty("消息编号")
    private long messageId;

    @ApiModelProperty("最近一条消息")
    private ChattingPayload message;

    @ApiModelProperty("未读数量")
    private long unReadNum;

}
