package com.spring.boxes.dollar.support.socket.payload;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

@ApiModel("拉取离线消息的Payload")
@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class ChatPullPayload extends AttachedPayload<Long> {

    @ApiModelProperty("会话ID")
    protected String roomId;

    @ApiModelProperty("发送用户")
    protected long fromId;

    @ApiModelProperty("接受者ID")
    protected long toId;

    @ApiModelProperty("消息类型")
    protected String metaType;

    @ApiModelProperty("聊天类型")
    protected String chatType;

    @ApiModelProperty("消息开始时间")
    private long beginTime;

    @ApiModelProperty("消息结束时间")
    private long stopTime;

    @ApiModelProperty("上一条消息cursorID")
    private long lastId;

    @ApiModelProperty("拉取消息数量")
    private int count;
}
