package com.spring.boxes.dollar.support.socket.payload;

import java.util.Map;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

@ApiModel("聊天对话消息的Payload")
@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class ChattingPayload extends AttachedPayload<Long> {

    @ApiModelProperty("会话ID")
    protected String roomId;

    @ApiModelProperty("发送用户")
    protected long fromId;

    @ApiModelProperty("发送者昵称")
    protected String fromName;

    @ApiModelProperty("发送者头像")
    protected String fromAvatar;

    @ApiModelProperty("发送者Meta")
    protected Map<String, Object> fromMeta;

    @ApiModelProperty("接受者ID")
    protected long toId;

    @ApiModelProperty("接受者昵称")
    protected String toName;

    @ApiModelProperty("接受者头像")
    protected String toAvatar;

    @ApiModelProperty("接收者Meta")
    protected Map<String, Object> toMeta;

    @ApiModelProperty("消息类型")
    protected String metaType;

    @ApiModelProperty("聊天类型")
    protected String chatType;

    @ApiModelProperty("消息内容")
    protected String content;

    @ApiModelProperty("附带消息")
    protected Map<String, Object> carry;

}
