package com.spring.boxes.dollar.support.socket.payload;

import com.spring.boxes.dollar.enums.ChatTypeEnum;
import com.spring.boxes.dollar.support.socket.ImSocket;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class RoomingPayload implements Serializable {

    @ApiModelProperty("聊天用户类型")
    private String type;

    @ApiModelProperty("用户编号")
    private long fomId;

    @ApiModelProperty("聊天对象ID")
    private long toId;

    public String getRoomId(){
        ChatTypeEnum chatType = ChatTypeEnum.Opt.INSTANCE().nameGet(type, ChatTypeEnum.SINGLE);
        return ImSocket.getRoomId(chatType, fomId, toId);
    }
}
