package com.spring.boxes.dollar.support.spring;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.Objects;

@Slf4j
public class SpringContext implements ApplicationContextAware {

    private static ApplicationContext context;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringContext.context = applicationContext;
    }

    private static void checkContext() {
        if (Objects.isNull(context)) {
            throw new IllegalStateException("ApplicationContextContext未注入, 请先示例化SpringContext");
        }
    }

    public static <T> T getBean(String name) throws BeansException {
        checkContext();
        return (T) context.getBean(name);
    }

    public static <T> T getBean(String name, Class<T> clazz) throws BeansException {
        checkContext();
        return (T) context.getBean(name, clazz);
    }

    public static <T> T getBean(Class<T> clazz) {
        checkContext();
        return context.getBean(clazz);
    }

    public static <T> Map<String, T> getBeansOfType(@Nullable Class<T> clazz){
        checkContext();
        return context.getBeansOfType(clazz);
    }

    public static ApplicationContext getContext() {
        checkContext();
        return context;
    }
}
