package com.spring.boxes.dollar.support.strategy.type;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class FrequencyArg implements Serializable {

    @ApiModelProperty("业务前缀Key")
    private String key;

    @ApiModelProperty("最大次数")
    private int maxCount;

    @ApiModelProperty("时间粒度")
    private TimeUnit timeUnit = TimeUnit.MINUTES;

    @ApiModelProperty("时间周期")
    private int timeInterval;

    @ApiModelProperty("异常码")
    private int exceptionCode;

    /**
     * 获取频控限制Key
     *
     * @return 频控Key
     */
    public String getFrequencyKey() {
        return String.format("_frequency_%s_%s", key, getSurvivalTime());
    }

    /**
     * 获取时间间隔粒度
     * @return 间隔时间长度
     */
    public long getSurvivalTime(){
        return timeUnit.toMillis(timeInterval);
    }

    public static long getThreeMinute() {
        return TimeUnit.MINUTES.toMillis(3);
    }

    public static long getOneMinute() {
        return TimeUnit.MINUTES.toMillis(1);
    }

    public static long getOneDaily() {
        return TimeUnit.DAYS.toMillis(1);
    }
}
