package com.spring.boxes.dollar.support.strategy.type;

import com.spring.boxes.dollar.CollectionUtils;
import com.spring.boxes.dollar.support.ApiException;
import com.spring.boxes.dollar.support.ApiStatus;
import com.spring.boxes.dollar.support.strategy.StrategyPayload;
import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.redis.core.StringRedisTemplate;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@Slf4j
@NoArgsConstructor
@AllArgsConstructor
public class FrequencyTemplate implements StrategyPayload<List<FrequencyArg>> {

    private StringRedisTemplate stringRedisTemplate;

    @Override
    public void filter(List<FrequencyArg> limitType) {
        if (!CollectionUtils.isEmpty(limitType)) {
            for (FrequencyArg frequencyArg : limitType) {
                String cacheKey = frequencyArg.getFrequencyKey();
                Long count = stringRedisTemplate.opsForValue().increment(cacheKey, 1);
                if (Objects.isNull(count)) {
                    return;
                }
                if (1 == count) {
                    stringRedisTemplate.expire(cacheKey, frequencyArg.getSurvivalTime(), TimeUnit.MILLISECONDS);
                }
                if (count > frequencyArg.getMaxCount()) {
                    log.error("key:{} maxCount:{} frequency limited", cacheKey, frequencyArg.getMaxCount());
                    throw new ApiException(ApiStatus.Status.FREQUENCY, "触发频控");
                }
            }
        }
    }
}
