package com.spring.boxes.dollar.support.strategy.type;

import com.spring.boxes.dollar.ShuntUtils;
import com.spring.boxes.dollar.support.ApiException;
import com.spring.boxes.dollar.support.ApiStatus;
import com.spring.boxes.dollar.support.strategy.StrategyPayload;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class GrayScaleTemplate implements StrategyPayload<GrayScaleArg> {

    @Override
    public void filter(GrayScaleArg arg) {
        boolean isHit = ShuntUtils.isOnFor(arg.getGrayConfig(), arg.getHashValue());
        if (isHit) {
            throw new ApiException(ApiStatus.Status.NO_PERMISSION, "灰度未命中");
        }
    }
}
