package com.spring.boxes.dollar.support.template;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class Template implements Serializable {

    @ApiModelProperty("模版编号")
    private long id;

    @ApiModelProperty("应用编号")
    private long appId;

    @ApiModelProperty("语言")
    private String language;

    @ApiModelProperty("模版CODE")
    private String code;

    @ApiModelProperty("目标标题")
    private String title;

    @ApiModelProperty("模版类型")
    private String type;

    @ApiModelProperty("参数列表")
    private List<String> argList;

    @ApiModelProperty("模版内容")
    private String content;
}
