package com.spring.boxes.dollar.support.template;

import com.spring.boxes.dollar.StringUtils;

import java.util.Map;

public interface TemplateLoader {

    /**
     * 查询指定应用、键、语言的本地化字符串模板
     *
     * @param appId 应用ID
     * @param key 模版键
     * @param language 语言
     * @return LocaleTemplate 本地化字符串模板对象
     */
    Template queryTemplate(long appId, String key, String language);

    /**
     * 字符串替换器
     *
     * @param content 需要进行替换的字符串
     * @param args    用于替换的参数，以Map形式传入
     * @return 替换后的字符串
     */
    default String substitutor(String content, Map<String, Object> args) {
        return StringUtils.substitutor(content, args);
    }
}
