package com.spring.boxes.dollar.support.translate;

import java.util.List;
import java.util.Map;

public interface TranslatePayload {

    /**
     * 根据指定的消息键和语言获取对应的文本信息
     *
     * @param messageKey 消息键，用于唯一标识一种文本信息
     * @param language   语言，表示需要获取的文本信息所使用的语言类型
     * @return 返回指定消息键对应的文本信息
     */
    String getText(String messageKey, String language);

    /**
     * 根据指定的消息键列表和语言获取对应的文本信息
     *
     * @param messageKeys 消息键列表，用于唯一标识一组文本信息
     * @param language    语言，表示需要获取的文本信息所使用的语言类型
     * @return 返回一个 Map 对象，其中 Key 表示消息键，Value 表示对应的文本信息
     */
    Map<String, String> getText(List<String> messageKeys, String language);
}
